/*
 * Decompiled with CFR 0.152.
 */
package me.angel.challenges6t4.challenge;

import me.angel.challenges6t4.challenge.ChallengeRegistry;
import me.angel.challenges6t4.challenge.ChallengeSettings;
import net.minecraft.class_2561;

public abstract class Challenge {
    private final String id;
    private final class_2561 name;
    private final class_2561 description;
    private boolean enabled;
    private boolean trueMode;
    private boolean hasOptions;
    private final MultiplayerStatus multiplayerStatus;

    protected Challenge(String id, class_2561 name, class_2561 description, boolean hasOptions) {
        this(id, name, description, hasOptions, MultiplayerStatus.SINGLE_PLAYER_ONLY);
    }

    protected Challenge(String id, class_2561 name, class_2561 description, boolean hasOptions, MultiplayerStatus multiplayerStatus) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.hasOptions = hasOptions;
        this.enabled = ChallengeSettings.isEnabled(id);
        this.trueMode = false;
        this.multiplayerStatus = multiplayerStatus;
    }

    public abstract boolean isGameBeatable();

    public abstract void onEnable();

    public abstract void onDisable();

    public String getId() {
        return this.id;
    }

    public class_2561 getName() {
        return this.name;
    }

    public class_2561 getDescription() {
        return this.description;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        if (this.enabled != enabled) {
            this.enabled = enabled;
            ChallengeSettings.setEnabled(this.id, enabled);
            if (enabled) {
                this.onEnable();
            } else {
                this.onDisable();
            }
            if (ChallengeSettings.isServerSide()) {
                ChallengeRegistry.syncToAllClients();
            }
        }
    }

    public void setEnabledClientSide(boolean enabled) {
        if (this.enabled != enabled) {
            this.enabled = enabled;
            if (enabled) {
                this.onEnable();
            } else {
                this.onDisable();
            }
        }
    }

    public boolean isTrueMode() {
        return this.trueMode;
    }

    public void setTrueMode(boolean trueMode) {
        this.trueMode = trueMode;
    }

    public boolean hasOptions() {
        return this.hasOptions;
    }

    public class_2561 getDisplayName() {
        return this.name;
    }

    public MultiplayerStatus getMultiplayerStatus() {
        return this.multiplayerStatus;
    }

    public boolean hasShowcaseVideo() {
        return this.getShowcaseVideoUrl() != null && !this.getShowcaseVideoUrl().isEmpty();
    }

    public String getShowcaseVideoUrl() {
        return null;
    }

    public static enum MultiplayerStatus {
        SINGLE_PLAYER_ONLY("Single Player Only"),
        MULTIPLAYER_COMPATIBLE("Works in Multiplayer"),
        MULTIPLAYER_ONLY("Multiplayer Only"),
        UNTESTED_MULTIPLAYER("Untested in Multiplayer - May still work"),
        EXPERIMENTAL("Experimental - May be incomplete or buggy or not work at all");

        private final String displayText;

        private MultiplayerStatus(String displayText) {
            this.displayText = displayText;
        }

        public String getDisplayText() {
            return this.displayText;
        }
    }
}

